#include <iostream>
#include <algorithm>
using namespace std;

using ll = long long;

ll sum_arithm(ll first, ll last, ll cnt) {
    // Сумма first, first+step, ..., last
    // step = k, cnt известно
    if (cnt <= 0) return 0;
    return (first + last) * cnt / 2;
}

int main() {
    ll n, m, k;
    cin >> n >> m >> k;

    ll low = min(n, m);
    ll high = max(n, m);
    ll total_diag = n + m - 1;

    ll ans[5] = {0};

    for (ll r = 0; r < k; r++) {
        ll cnt1 = 0, sum1 = 0;

        // 1. Возрастание: d = 0 .. low-1, len = d+1
        if (r <= low - 1) {
            ll first_d = r;
            ll last_d = r + ((low - 1 - r) / k) * k;
            ll cnt = (last_d - first_d) / k + 1;
            // сумма len = сумма (d+1) = сумма d + cnt
            ll sum_d = sum_arithm(first_d, last_d, cnt);
            sum1 = sum_d + cnt;
        }

        // 2. Постоянство: d = low .. high-1, len = low
        ll first_d2 = low + ((r - low % k + k) % k);
        ll sum2 = 0;
        if (first_d2 <= high - 1) {
            ll last_d2 = first_d2 + ((high - 1 - first_d2) / k) * k;
            ll cnt = (last_d2 - first_d2) / k + 1;
            sum2 = low * cnt;
        }

        // 3. Убывание: d = high .. total_diag-1, len = total_diag - d
        ll first_d3 = high + ((r - high % k + k) % k);
        ll sum3 = 0;
        if (first_d3 <= total_diag - 1) {
            ll last_d3 = first_d3 + ((total_diag - 1 - first_d3) / k) * k;
            ll cnt = (last_d3 - first_d3) / k + 1;
            // сумма len = сумма (total_diag - d) = total_diag*cnt - сумма d
            ll sum_d3 = sum_arithm(first_d3, last_d3, cnt);
            sum3 = total_diag * cnt - sum_d3;
        }

        ans[r] = sum1 + sum2 + sum3;
    }

    for (int i = 0; i < k; i++) {
        cout << ans[i] << "\n";
    }

    return 0;
}