#include <iostream>
#include <vector>
#include <string>
using namespace std;

const int MOD = 1000000007;

string get_binary(string s) {
    string bin = "";
    while (s != "0") {
        int rem = 0;
        string next = "";
        for (char c : s) {
            int d = c - '0';
            int new_d = (rem * 10 + d) / 2;
            rem = (rem * 10 + d) % 2;
            if (!next.empty() || new_d > 0) next += char('0' + new_d);
        }
        if (next.empty()) next = "0";
        bin = char('0' + rem) + bin;
        s = next;
    }
    if (bin.empty()) bin = "0";
    return bin;
}

int main() {
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    string bin = get_binary(R);
    int L = bin.size();
    vector<vector<long long>> dp(2, vector<long long>(K, 0));
    dp[1][0] = 1;
    for (int pos = 0; pos < L; pos++) {
        int digit = bin[pos] - '0';
        vector<vector<long long>> new_dp(2, vector<long long>(K, 0));
        vector<long long> temp(K);
        for (int mod = 0; mod < K; mod++) {
            temp[mod] = dp[0][mod];
            new_dp[0][mod] = (new_dp[0][mod] + dp[0][mod]) % MOD;
        }
        for (int mod = 0; mod < K; mod++) {
            int new_mod = (mod + 1) % K;
            new_dp[0][new_mod] = (new_dp[0][new_mod] + temp[mod]) % MOD;
        }
        if (digit == 0) {
            for (int mod = 0; mod < K; mod++) {
                new_dp[1][mod] = (new_dp[1][mod] + dp[1][mod]) % MOD;
            }
        } else {
            for (int mod = 0; mod < K; mod++) {
                new_dp[0][mod] = (new_dp[0][mod] + dp[1][mod]) % MOD;
            }
        }
        if (digit >= 1) {
            if (digit == 1) {
                for (int mod = 0; mod < K; mod++) {
                    int new_mod = (mod + 1) % K;
                    new_dp[1][new_mod] = (new_dp[1][new_mod] + dp[1][mod]) % MOD;
                }
            } else {
                for (int mod = 0; mod < K; mod++) {
                    int new_mod = (mod + 1) % K;
                    new_dp[0][new_mod] = (new_dp[0][new_mod] + dp[1][mod]) % MOD;
                }
            }
        }
        dp = new_dp;
    }
    long long ans = (dp[0][0] + dp[1][0]) % MOD;
    cout << ans << endl;
    return 0;
}
