#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const int MOD = 1000000007;

string to_binary(string s) {
    string bin = "";
    while (s != "0") {
        int rem = 0;
        string next = "";
        for (char c : s) {
            int d = c - '0';
            int val = rem * 10 + d;
            next += char('0' + val / 2);
            rem = val % 2;
        }
        // remove leading zeros from next
        size_t start = next.find_first_not_of('0');
        if (start == string::npos) next = "0";
        else next = next.substr(start);
        bin = char('0' + rem) + bin;
        s = next;
    }
    if (bin.empty()) bin = "0";
    return bin;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    int n, K;
    cin >> n >> K;
    string R;
    cin >> R;
    string bin = to_binary(R);
    const int L = 100000;
    while (bin.size() < L) bin = "0" + bin;
    vector<ll> tight_dp(K, 0);
    vector<ll> non_tight_dp(K, 0);
    tight_dp[0] = 1;
    for (int pos = 0; pos < L; ++pos) {
        vector<ll> new_tight(K, 0);
        vector<ll> new_non(K, 0);
        int maxd = bin[pos] - '0';
        // process tight_dp
        for (int mod = 0; mod < K; ++mod) {
            if (tight_dp[mod] == 0) continue;
            // d=0
            int new_mod = mod;
            int new_t = (0 == maxd) ? 1 : 0;
            if (new_t) new_tight[new_mod] = (new_tight[new_mod] + tight_dp[mod]) % MOD;
            else new_non[new_mod] = (new_non[new_mod] + tight_dp[mod]) % MOD;
            // d=1 if possible
            if (maxd >= 1) {
                new_mod = (mod + 1) % K;
                new_t = (1 == maxd) ? 1 : 0;
                if (new_t) new_tight[new_mod] = (new_tight[new_mod] + tight_dp[mod]) % MOD;
                else new_non[new_mod] = (new_non[new_mod] + tight_dp[mod]) % MOD;
            }
        }
        // process non_tight_dp
        for (int mod = 0; mod < K; ++mod) {
            new_non[mod] = (new_non[mod] + non_tight_dp[mod]) % MOD;
            int prev = (mod - 1 + K) % K;
            new_non[mod] = (new_non[mod] + non_tight_dp[prev]) % MOD;
        }
        // for d=1 from non_tight
        for (int mod = 0; mod < K; ++mod) {
            if (non_tight_dp[mod] == 0) continue;
            int new_mod = (mod + 1) % K;
            new_tight[new_mod] = (new_tight[new_mod] + non_tight_dp[mod]) % MOD;
        }
        tight_dp = move(new_tight);
        non_tight_dp = move(new_non);
    }
    ll ans = (tight_dp[0] + non_tight_dp[0]) % MOD;
    cout << ans << '\n';
    return 0;
}
