#include <iostream>
#include <vector>
using namespace std;

const int N = 1000000;
vector<int> p(N + 1);
vector<bool> ok(N + 1, true);

void sieve() {
    for (int i = 0; i <= N; i++) p[i] = i;
    for (int i = 2; i * i <= N; i++) {
        if (p[i] == i) {
            for (int j = i * i; j <= N; j += i) {
                if (p[j] == j) p[j] = i;
            }
        }
    }
}

void pre() {
    ok[1] = false;
    for (int i = 2; i <= N; i++) {
        int n = i;
        bool f = true;
        while (n > 1) {
            int q = p[n];
            int c = 0;
            while (n % q == 0) {
                n /= q;
                c++;
            }
            if (c % 2 == 0) f = false;
        }
        ok[i] = f;
    }
}

int main() {
    sieve();
    pre();
    int m;
    cin >> m;
    int l, r;
    cin >> l >> r;
    int s = 0;
    int st = -1;
    for (int i = l; i <= r; i++) {
        if (ok[i]) {
            s++;
            if (s >= m) {
                st = i - m + 1;
                break;
            }
        } else {
            s = 0;
        }
    }
    if (st == -1) {
        cout << -1 << endl;
    } else {
        for (int i = 0; i < m; i++) {
            if (i > 0) cout << " ";
            cout << (st + i);
        }
        cout << endl;
    }
    return 0;
}
