def check_line(x1, y1, x2, y2, rects):
    for rx1, ry1, rx2, ry2 in rects:
        found = False
        for xx in [rx1, rx2]:
            y_line = y1 + (y2 - y1)*(xx - x1)/(x2 - x1) if x2 != x1 else None
            if y_line is not None and ry1 <= y_line <= ry2:
                found = True
        for yy in [ry1, ry2]:
            x_line = x1 + (x2 - x1)*(yy - y1)/(y2 - y1) if y2 != y1 else None
            if x_line is not None and rx1 <= x_line <= rx2:
                found = True
        if not found:
            return False
    return True

T = int(input())
results = []

for _ in range(T):
    n = int(input())
    rects = [tuple(map(int, input().split())) for _ in range(n)]
    found = False
    candidates = [
        (rects[0][0], rects[0][1], rects[-1][0], rects[-1][1]),
        (rects[0][0], rects[0][3], rects[-1][0], rects[-1][3]),
        (rects[0][2], rects[0][1], rects[-1][2], rects[-1][1]),
        (rects[0][2], rects[0][3], rects[-1][2], rects[-1][3]),
    ]
    for x1, y1, x2, y2 in candidates:
        if check_line(x1, y1, x2, y2, rects):
            found = True
            break
    results.append("Yes" if found else "No")

for r in results:
    print(r)

