﻿#include <iostream>
#include <algorithm>
#include <climits>
#include <iomanip>
#include <deque>
#include <queue>
#include <vector>
#include <numeric>
#include <cmath>
#include <set>
#include <map>
#include <unordered_map>
#include <string>
#include <sstream>
#include <fstream>

using namespace std;
typedef long long ll;

bool is_prime(ll num) {
    for (int i = 2; i * i <= num; i++) {
        if (num % i == 0) {
            return 0;
        }
    }

    return 1;
}

bool check(ll num, vector<ll> &primes) {
    for (int i: primes) {
        if (i * i > num) {
            return 1;
        };

        ll count = 0;
        if (binary_search(primes.begin(), primes.end(), i)) {
            while (num % i == 0) {
                num /= i;
                count++;
            }
        }

        if (count % 2 == 0 and count != 0) {
            return 0;
        }
    }

    return 1;
}

int main()
{
    cin.tie(nullptr);
    ios_base::sync_with_stdio(false);

    ll lim = 1000000;
    vector<ll> primes;
    vector<ll> checked(lim);

    for (ll i = 2; i < lim; i++) {
        if (checked[i] == 0) {
            primes.push_back(i);
            for (ll j = i * i; j < lim; j += i) {
                checked[j] = 1;
            }
        }
    }

    ll m, l, r;
    cin >> m >> l >> r;

    ll streak = 0;
    vector<ll> ans;

    for (ll i = l; i <= r; i++) {
        if (streak == m) {
            break;
        }

        if (check(i, primes)) {
            streak++;
            ans.push_back(i);
        }
        else {
            streak = 0;
            ans.clear();
        }
    }

    if (streak < m) {
        cout << -1;
        return 0;
    }
    else {
        for (ll i : ans) {
            cout << i << ' ';
        }
    }



    return 0;
}