import sys

sys.setrecursionlimit(200000)
MOD = 10**9 + 7

def solve_optimized():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        
        parts = list(map(int, line1.split()))
        
        if not parts:
            line1 = sys.stdin.readline()
            if not line1:
                return
            parts = list(map(int, line1.split()))

        if len(parts) == 2:
            n, K = parts
            R_str = sys.stdin.readline().strip()
        else:
            n = parts[0]
            K = parts[1]
            if len(parts) > 2:
                R_str = "".join(map(str, parts[2:]))
            else:
                R_str = sys.stdin.readline().strip()

        if K == 0:
            print(0)
            return

        R_int = int(R_str)
        if R_int == 0:
            print(1 % MOD)
            return
            
        binary_R = bin(R_int)[2:]
        m = len(binary_R)

        # Предварительный расчет биномиальных коэффициентов C(n, k) modulo MOD
        MAX_BITS = m + 5
        C = [[0] * MAX_BITS for _ in range(MAX_BITS)]
        for i in range(MAX_BITS):
            C[i][0] = 1
            for j in range(1, i + 1):
                C[i][j] = (C[i-1][j-1] + C[i-1][j]) % MOD
        
        def combinations(nn, kk):
            if kk < 0 or kk > nn:
                return 0
            return C[nn][kk]

        # Функция для подсчета чисел x < R с popcount(x) % K == 0
        
        def count_valid(binary_str, K_val):
            length = len(binary_str)
            count = 0
            set_bits_so_far = 0

            for i in range(length):
                # Если текущий бит в R равен '1', мы можем поставить '0' здесь
                # и заполнить оставшиеся позиции любым образом, чтобы popcount % K == 0
                if binary_str[i] == '1':
                    remaining_bits = length - 1 - i
                    # Нужно дополнить текущее количество единиц до числа, кратного K
                    
                    # Перебираем возможное количество единиц (j) в оставшихся битах
                    # set_bits_so_far + j = q * K
                    # j = q * K - set_bits_so_far
                    # 0 <= j <= remaining_bits
                    
                    # Iterate through multiples of K
                    q = 0
                    while True:
                        j = q * K - set_bits_so_far
                        if j > remaining_bits:
                            break
                        if j >= 0:
                            count = (count + combinations(remaining_bits, j)) % MOD
                        q += 1
                
                # Обновляем количество установленных бит для текущего префикса
                if binary_str[i] == '1':
                    set_bits_so_far += 1
                
                # Если дошли до конца, и само R удовлетворяет условию, добавляем его
                if i == length - 1 and set_bits_so_far % K_val == 0:
                    count = (count + 1) % MOD # Это считает само R
            
            # Примечание: цикл выше уже включает R в счет.
            return count
        
        # Эта функция считает числа в диапазоне [0, R], включая R.
        result = count_valid(binary_R, K)
        print(result)

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve_optimized()

