import sys

sys.setrecursionlimit(2000000)

def solve():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        
        line1 = line1.split()
        if not line1:
            return solve()
        
        T = int(line1)
        for _ in range(T):
            line = sys.stdin.readline()
            if not line:
                continue
            line_parts = line.split()
            if not line_parts:
                line = sys.stdin.readline()
                if not line:
                    continue
                line_parts = line.split()
            
            n = int(line_parts)
            
            rects = []
            for _ in range(n):
                line = sys.stdin.readline()
                if not line:
                    continue
                coords = list(map(int, line.split()))
                if not coords:
                    coords = list(map(int, sys.stdin.readline().split()))
                x1, y1, x2, y2 = coords
                rects.append((x1, y1, x2, y2))
            
            # Проверка 4 направлений (горизонталь, вертикаль, 45, 135)
            # Горизонтальная
            max_y1 = -float('inf')
            min_y2 = float('inf')
            for r in rects:
                max_y1 = max(max_y1, r[1])
                min_y2 = min(min_y2, r[3])
            if max_y1 <= min_y2:
                print("Yes")
                continue

            # Вертикальная
            max_x1 = -float('inf')
            min_x2 = float('inf')
            for r in rects:
                max_x1 = max(max_x1, r[0])
                min_x2 = min(min_x2, r[2])
            if max_x1 <= min_x2:
                print("Yes")
                continue
            
            # Диагональ 45 (u = x - y, ищем общую u)
            max_u1 = -float('inf')
            min_u2 = float('inf')
            for r in rects:
                max_u1 = max(max_u1, r[0] - r[3])
                min_u2 = min(min_u2, r[2] - r[1])
            if max_u1 <= min_u2:
                print("Yes")
                continue

            # Диагональ 135 (v = x + y, ищем общую v)
            max_v1 = -float('inf')
            min_v2 = float('inf')
            for r in rects:
                max_v1 = max(max_v1, r[0] + r[1])
                min_v2 = min(min_v2, r[2] + r[3])
            if max_v1 <= min_v2:
                print("Yes")
                continue
            
            print("No")

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve()

