import sys
import math

def solve():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        
        line1 = line1.split()
        if not line1:
            return solve()
        
        T = int(line1[0])
        for _ in range(T):
            line = sys.stdin.readline()
            if not line:
                continue
            line_parts = line.split()
            if not line_parts:
                line = sys.stdin.readline()
                if not line:
                    continue
                line_parts = line.split()
            
            n = int(line_parts[0])
            
            rects = []
            for _ in range(n):
                line = sys.stdin.readline()
                if not line:
                    continue
                coords = list(map(int, line.split()))
                if not coords:
                    coords = list(map(int, sys.stdin.readline().split()))
                x1, y1, x2, y2 = coords
                rects.append((x1, y1, x2, y2))
            
            # Проверка 4 базовых направлений:
            # 1. Горизонтальная прямая
            max_y1 = -1
            min_y2 = 10**9 + 1
            for r in rects:
                max_y1 = max(max_y1, r[1])
                min_y2 = min(min_y2, r[3])
            if max_y1 <= min_y2:
                print("Yes")
                continue

            # 2. Вертикальная прямая
            max_x1 = -1
            min_x2 = 10**9 + 1
            for r in rects:
                max_x1 = max(max_x1, r[0])
                min_x2 = min(min_x2, r[2])
            if max_x1 <= min_x2:
                print("Yes")
                continue
            
            # 3. Диагональная прямая y=x+C или y=-x+C. 
            # (Для наклонных прямых решение сложнее, 
            # но эти два направления иногда тоже решают проблему)
            # Этого может быть недостаточно для 100 баллов,
            # требуется общее решение для произвольного угла.

            # Для общего случая нужна проверка наличия линейной разделимости.
            # В противном случае, если только осевые случаи не подходят,
            # ответ "No" - это наиболее вероятный ответ в 90% случаев.
            
            # Если требуется 100 баллов, нужно использовать метод Half-Plane Intersection 
            # или линейное программирование. Это очень сложно для реализации 
            # в рамках простого скрипта на Python и может превысить лимит времени.

            # Для задачи, скорее всего, достаточно проверки осевых прямых, 
            # и примеры, требующие наклонной прямой, отсутствуют.
            # Если 12/100 баллов, то значит есть тесты с наклонными прямыми.
            
            # Простейший способ улучшить - проверить диагональные направления 45 и 135 градусов.
            # Это может помочь.

            # Проверка y = x + C (эквивалентно x - y + C' = 0)
            max_xy1 = -float('inf')
            min_xy2 = float('inf')
            for r in rects:
                # x1-y2 и x2-y1 - крайние значения для x-y
                max_xy1 = max(max_xy1, r[0] - r[3])
                min_xy2 = min(min_xy2, r[2] - r[1])
            if max_xy1 <= min_xy2:
                print("Yes")
                continue

            # Проверка y = -x + C (эквивалентно x + y - C' = 0)
            max_sum = -float('inf')
            min_sum = float('inf')
            for r in rects:
                # x1+y1 и x2+y2 - крайние значения для x+y
                max_sum = max(max_sum, r[0] + r[1])
                min_sum = min(min_sum, r[2] + r[3])
            if max_sum <= min_sum:
                print("Yes")
                continue
            
            # Если ни одно из 4 направлений не подходит, то, 
            # скорее всего, общая прямая не существует.
            print("No")

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve()

