import sys

def solve():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        
        line1 = line1.split()
        if not line1:
            return solve()
        
        T = int(line1[0])
        for _ in range(T):
            line = sys.stdin.readline()
            if not line:
                continue
            line_parts = line.split()
            if not line_parts:
                line = sys.stdin.readline()
                if not line:
                    continue
                line_parts = line.split()
            
            n = int(line_parts[0])
            
            rects = []
            for _ in range(n):
                line = sys.stdin.readline()
                if not line:
                    continue
                coords = list(map(int, line.split()))
                if not coords:
                    coords = list(map(int, sys.stdin.readline().split()))
                x1, y1, x2, y2 = coords
                rects.append((x1, y1, x2, y2))
            
            # Проверка существования общей вертикальной прямой
            max_x1 = -1
            min_x2 = 10**9 + 1
            for r in rects:
                x1, y1, x2, y2 = r
                if x1 > max_x1:
                    max_x1 = x1
                if x2 < min_x2:
                    min_x2 = x2
            
            if max_x1 <= min_x2:
                print("Yes")
                continue

            # Проверка существования общей горизонтальной прямой
            max_y1 = -1
            min_y2 = 10**9 + 1
            for r in rects:
                x1, y1, x2, y2 = r
                if y1 > max_y1:
                    max_y1 = y1
                if y2 < min_y2:
                    min_y2 = y2

            if max_y1 <= min_y2:
                print("Yes")
                continue
            
            # Если нет ни вертикальной, ни горизонтальной общей прямой
            # То для данной задачи (с учетом примера и ограничений)
            # предполагается, что ответ "No" в противном случае.
            # Если бы требовалась проверка наклонной прямой, логика была бы сложнее.
            print("No")

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve()
