import sys

sys.setrecursionlimit(200000)
MOD = 10**9 + 7
# Предварительно определим максимальный размер, будет скорректирован позже
MAX_M = 200005 

fact = []
invFact = []

def power_with_modulo(base, exp):
    res = 1
    base %= MOD
    while exp > 0:
        if exp % 2 == 1:
            res = (res * base) % MOD
        base = (base * base) % MOD
        exp //= 2
    return res

def mod_inverse(n):
    return power_with_modulo(n, MOD - 2)

def precompute_factorials(m_val):
    global fact, invFact, MAX_M
    MAX_M = m_val + 5
    fact = [1] * MAX_M
    invFact = [1] * MAX_M
    for i in range(1, MAX_M):
        fact[i] = (fact[i-1] * i) % MOD
    invFact[MAX_M-1] = mod_inverse(fact[MAX_M-1])
    for i in range(MAX_M-2, -1, -1):
        invFact[i] = (invFact[i+1] * (i+1)) % MOD

def get_combinations_mod_fact(nn, kk):
    if kk < 0 or kk > nn:
        return 0
    return (fact[nn] * invFact[kk] * invFact[nn-kk]) % MOD

def count_valid_final(binary_str, K_val):
    length = len(binary_str)
    count = 0
    set_bits_so_far = 0
    for i in range(length):
        if binary_str[i] == '1':
            remaining_bits = length - 1 - i
            start_q = (set_bits_so_far + K_val) // K_val
            end_q = (remaining_bits + set_bits_so_far) // K_val
            for q in range(start_q, end_q + 1):
                j = q * K_val - set_bits_so_far
                if 0 <= j <= remaining_bits:
                    count = (count + get_combinations_mod_fact(remaining_bits, j)) % MOD
            set_bits_so_far += 1
            
    if set_bits_so_far % K_val == 0:
        count = (count + 1) % MOD
    return count

def solve_optimized_final():
    try:
        # Читаем весь ввод и разделяем его
        data = sys.stdin.read().split()
        if not data:
            return
        
        # Правильное извлечение n, K и R_str
        n = int(data[0])
        K = int(data[1])
        # Объединяем оставшиеся части в одну строку R
        R_str = "".join(data[2:])
            
        if K == 0:
            print(0)
            return
        
        R_int = int(R_str)
        if R_int == 0:
            print(1 % MOD)
            return

        binary_R = bin(R_int)[2:]
        m = len(binary_R)

        precompute_factorials(m)
        
        result = count_valid_final(binary_R, K)
        print(result)
    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve_optimized_final()
