import sys

sys.setrecursionlimit(200000)
MOD = 10**9 + 7

def solve_optimized_speed_dp():
    try:
        # --- Блок чтения входных данных ---
        data_lines = sys.stdin.read().split()
        if not data_lines:
            return

        n = int(data_lines)
        K = int(data_lines)
        R_str = "".join(data_lines[2:])
        
        if K == 0:
            print(0)
            return

        R_int = int(R_str)
        if R_int == 0:
            print(1 % MOD)
            return
            
        binary_R = bin(R_int)[2:]
        m = len(binary_R)

        # --- Динамическое программирование с мемоизацией ---
        # Используем словарь для мемоизации, чтобы не превышать лимит памяти 64 МБ,
        # надеясь, что количество состояний (index, popcount_mod, is_less) не слишком велико.
        
        memo = {}

        def dp(index, current_popcount_mod_K, is_less):
            if index == m:
                return 1 if current_popcount_mod_K == 0 else 0
            
            state = (index, current_popcount_mod_K, is_less)
            if state in memo:
                return memo[state]

            upper_bound = int(binary_R[index]) if not is_less else 1
            count = 0

            for digit in range(upper_bound + 1):
                new_is_less = is_less or (digit < upper_bound)
                new_popcount_mod_K = (current_popcount_mod_K + digit) % K
                count = (count + dp(index + 1, new_popcount_mod_K, new_is_less)) % MOD

            memo[state] = count
            return count

        result = dp(0, 0, False)
        print(result)
        
        # Очищаем кэш после использования
        memo.clear()

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve_optimized_speed_dp()
