import sys

# Увеличиваем лимит рекурсии, хотя в этом решении рекурсия не используется
sys.setrecursionlimit(200000) 

MOD = 10**9 + 7

def solve_optimized_final():
    try:
        # --- Блок чтения входных данных ---
        # Обрабатываем различные варианты ввода, чтобы быть надежными
        
        data_lines = sys.stdin.read().split()
        if not data_lines:
            return

        # Извлекаем n и K из первых элементов списка
        n_str = data_lines[0]
        K_str = data_lines[1]
        n = int(n_str)
        K = int(K_str)
        
        # Собираем строку R из оставшихся частей данных (она может быть длинной)
        R_str = "".join(data_lines[2:])
        
        if not R_str:
             # Если R не было в data_lines, значит оно было в первой строке или в другом месте
             # Это маловероятно при корректном вводе, но на всякий случай
             R_str = data_lines[-1] 

        # --- Основная логика ---

        if K == 0:
            print(0)
            return

        R_int = int(R_str)
        if R_int == 0:
            print(1 % MOD)
            return
            
        # Преобразуем R в двоичную строку
        binary_R = bin(R_int)[2:]
        m = len(binary_R) # Длина двоичного представления (порядка 100000)

        # Предварительный расчет биномиальных коэффициентов C(nn, kk) modulo MOD
        # Нам понадобятся коэффициенты до C(m, m)
        
        # Используем массив массивов для C[i][j], чтобы избежать повторных вычислений
        # Это самое ресурсоемкое по памяти место, но оно должно уложиться.
        
        # Максимальное количество бит около 100000. Это все еще слишком много для 2D массива в 64Мб.
        
        # Вместо 2D массива будем считать C(n, k) на лету или использовать оптимизированный 
        # одномерный массив, если K очень маленькое, но K до 100000.
        
        # Оптимальный подход: использовать только ту строку биномиальных коэффициентов C(m, *)
        # которая нам нужна, или генерировать их по требованию, но это медленно.
        
        # Используем факт, что нам нужны C(len - 1 - i, j) где i от 0 до len-1.
        # То есть нам нужны все C(X, Y) где X <= m.

        # Генерируем все необходимые C(n, k) до C(m, m)
        # Это потребует O(m^2) памяти/времени. m ~ 10^5, m^2 ~ 10^10, что невозможно.

        # --- Ключевая оптимизация: нам не нужен весь треугольник Паскаля! ---
        # Нам нужны только конкретные C(remaining_bits, j).
        
        # Заново реализуем count_valid с расчетом C(n, k) на лету (медленно)
        # Или используем Python's math.comb (быстро, но без модуля)
        
        # Используем собственную функцию для комбинаций с мемоизацией, 
        # но только для нужных нам значений.
        
        from functools import lru_cache

        @lru_cache(None)
        def combinations(nn, kk):
            if kk < 0 or kk > nn:
                return 0
            if kk == 0 or kk == nn:
                return 1
            if kk > nn // 2:
                kk = nn - kk
            
            # This needs a better calculation for large N/K with modulo
            # A simple recursive implementation with cache might hit recursion depth/speed issues
            
            # Standard iterative C(n, k) with modulo
            res = 1
            for i in range(kk):
                # We need modular inverse here, which is complex in Python
                pass # This path is hard

            # Let's stick with the math.comb idea, but implement modulo
            # Precompute factorials and their inverses

        # Реализация функции подсчета с использованием комбинаторики
        def count_valid_optimized(binary_str, K_val):
            length = len(binary_str)
            count = 0
            set_bits_so_far = 0

            # Для подсчета C(n, k) % MOD без 2D массива
            # Используем scipy.special.comb если разрешено, но нет, только стандартная библиотека.
            # Мы можем использовать генератор строк треугольника Паскаля по мере необходимости.
            
            # --- Самое эффективное решение: использовать scipy.special.comb если возможно, или 
            # использовать precomputation of one row at a time. ---
            
            # Поскольку мы не можем использовать сторонние библиотеки, и precomputation of all C(n,k) is slow/large
            # Нам придется использовать генерацию C(n, k) для каждой точки останова i.
            # Это O(length * K), что в пределах времени.

            for i in range(length):
                if binary_str[i] == '1':
                    remaining_bits = length - 1 - i
                    
                    # Подсчитываем C(remaining_bits, j) для нужных j
                    # Это можно сделать быстро, если K не гигантское, 
                    # но оно может быть до 100000.
                    
                    # Перебираем q так, чтобы j = q * K - set_bits_so_far
                    start_q = (set_bits_so_far // K_val)
                    if set_bits_so_far % K_val != 0:
                        start_q += 1

                    for q in range(start_q, (remaining_bits + set_bits_so_far) // K_val + 1):
                        j = q * K_val - set_bits_so_far
                        if 0 <= j <= remaining_bits:
                            # Здесь нужна функция для C(remaining_bits, j) % MOD
                            # Она должна работать быстро
                            count = (count + get_combinations_mod(remaining_bits, j)) % MOD
                        
                if binary_str[i] == '1':
                    set_bits_so_far += 1
                
                # Если дошли до конца, проверяем само R
                if i == length - 1 and set_bits_so_far % K_val == 0:
                    count = (count + 1) % MOD 
            
            return count
        
        # --- Helper function for combinations MOD ---
        # Для больших N и K нужна быстрая функция C(n, k)
        # Эта функция будет вызываться много раз, поэтому нужна мемоизация/эффективность.
        
        # Используем мемоизацию для C(n, k)
        comb_cache = {}
        def get_combinations_mod(nn, kk):
            if kk < 0 or kk > nn:
                return 0
            if kk == 0 or kk == nn:
                return 1
            if kk > nn // 2:
                kk = nn - kk
            if (nn, kk) in comb_cache:
                return comb_cache[(nn, kk)]
            
            # This naive calculation will TLE due to repeated computation
            # Need a better precomputed way. 
            # The only way is to not precompute the full triangle.
            
            # Standard way is to use factorials and modular inverse
            # Requires precomputing m factorials O(m) memory/time
            
            # We can use factorials. m ~ 100000
            pass # Use factorials approach below
        
        # Precompute factorials
        MAX_M = m + 5
        fact = [1] * MAX_M
        for i in range(1, MAX_M):
            fact[i] = (fact[i-1] * i) % MOD

        def power_with_modulo(base, exp):
            res = 1
            base %= MOD
            while exp > 0:
                if exp % 2 == 1:
                    res = (res * base) % MOD
                base = (base * base) % MOD
                exp //= 2
            return res

        def mod_inverse(n):
            return power_with_modulo(n, MOD - 2) # Fermat's Little Theorem

        def get_combinations_mod_fact(nn, kk):
            if kk < 0 or kk > nn:
                return 0
            # C(n, k) = n! / (k! * (n-k)!)
            numerator = fact[nn]
            denominator = (fact[kk] * fact[nn-kk]) % MOD
            return (numerator * mod_inverse(denominator)) % MOD

        # --- Запуск с использованием функции факториалов ---

        def count_valid_final(binary_str, K_val):
            length = len(binary_str)
            count = 0
            set_bits_so_far = 0

            for i in range(length):
                if binary_str[i] == '1':
                    remaining_bits = length - 1 - i
                    start_q = (set_bits_so_far // K_val)
                    if set_bits_so_far % K_val != 0:
                        start_q += 1

                    for q in range(start_q, (remaining_bits + set_bits_so_far) // K_val + 1):
                        j = q * K_val - set_bits_so_far
                        if 0 <= j <= remaining_bits:
                            count = (count + get_combinations_mod_fact(remaining_bits, j)) % MOD
                        
                if binary_str[i] == '1':
                    set_bits_so_far += 1
                
                if i == length - 1 and set_bits_so_far % K_val == 0:
                    count = (count + 1) % MOD 
            
            return count


        result = count_valid_final(binary_R, K)
        print(result)

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve_optimized_final()

