import sys
from functools import lru_cache

sys.setrecursionlimit(2000000) # Увеличиваем лимит рекурсии

MOD = 10**9 + 7

def solve():
    # Чтение входных данных из stdin
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        parts = list(map(int, line1.split()))
        if not parts:
            return

        n, K = parts
        
        line2 = sys.stdin.readline()
        if not line2:
            return
        R_str = line2.strip()
    except EOFError:
        return
    except ValueError:
        return

    # Преобразование R в целое число и затем в двоичную строку
    try:
        R_int = int(R_str)
        R_bin = bin(R_int)[2:] # Удаляем префикс '0b'
    except ValueError:
        return

    B = R_bin
    L = len(B)

    @lru_cache(None)
    def dp(index, count_ones, is_less):
        if index == L:
            # Базовый случай: достигли конца строки, 
            # проверяем условие popcount % K == 0
            return 1 if count_ones % K == 0 else 0

        # Определяем верхний предел для текущей цифры:
        # Если мы еще не "ушли вниз" (is_less == False), 
        # то текущая цифра может быть максимум B[index] (как число).
        # Иначе - может быть 1.
        upper_bound = int(B[index]) if not is_less else 1
        
        ans = 0
        for digit in range(upper_bound + 1):
            # Обновляем состояние:
            # new_is_less будет True, если мы уже были is_less, 
            # ИЛИ если мы сейчас выбрали цифру меньше, чем в R.
            new_is_less = is_less or (digit < upper_bound)
            
            # Обновляем количество единиц
            new_count_ones = count_ones + digit
            
            ans = (ans + dp(index + 1, new_count_ones, new_is_less)) % MOD
            
        return ans

    result = dp(0, 0, False)
    # Очищаем кэш после использования
    dp.cache_clear()
    
    print(result)

if __name__ == "__main__":
    solve()

