import sys

sys.setrecursionlimit(2000000)

def solve_problem():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        parts1 = list(map(int, line1.split()))
        if not parts1:
            return
        m = parts1[0]

        line2 = sys.stdin.readline()
        if not line2:
            return
        parts2 = list(map(int, line2.split()))
        if not parts2:
            return
        l, r = parts2
    except EOFError:
        return
    except ValueError:
        return
    
    max_r = 1000000
    if r > max_r:
        max_r = r # Should stay within the constraint 10^6

    spf = [i for i in range(max_r + 1)] # Smallest Prime Factor
    for i in range(2, int(max_r**0.5) + 1):
        if spf[i] == i:
            for j in range(i*i, max_r + 1, i):
                if spf[j] == j:
                    spf[j] = i
    
    is_odd_power = [False] * (r - l + 1)

    for i in range(l, r + 1):
        num = i
        is_odd = True
        while num > 1:
            p = spf[num]
            count = 0
            while num % p == 0:
                count += 1
                num //= p
            if count % 2 == 0:
                is_odd = False
                break
        if is_odd:
            is_odd_power[i - l] = True
    
    count_consecutive = 0
    start_index = -1
    for i in range(len(is_odd_power)):
        if is_odd_power[i]:
            if count_consecutive == 0:
                start_index = i
            count_consecutive += 1
            if count_consecutive == m:
                result_seq = list(range(l + start_index, l + start_index + m))
                print(*(result_seq))
                return
        else:
            count_consecutive = 0
            start_index = -1
    
    print("-1")

if __name__ == "__main__":
    solve_problem()
