import sys

def count_magic(n):
    if n < 7:
        return 0

    count_div7 = n // 7
    count_end7 = (n - 7) // 10 + 1
    count_both = (n - 7) // 70 + 1

    return count_div7 + count_end7 - count_both

def solve():
    try:
        line = sys.stdin.readline()
        if not line:
            return
        k = int(line)
    except ValueError:
        return

    left, right = 1, 10**18  # Верхняя граница достаточна
    ans = right

    while left <= right:
        mid = (left + right) // 2
        if count_magic(mid) >= k:
            ans = mid
            right = mid - 1
        else:
            left = mid + 1
            
    print(ans)

if __name__ == '__main__':
    solve()
