import sys

def solve_final_optimized():
    """
    Рассчитывает количество клеток каждого цвета полностью математически.
    """
    try:
        # Чтение входных данных
        line1 = sys.stdin.readline()
        if not line1: return
        line2 = sys.stdin.readline()
        if not line2: return
        line3 = sys.stdin.readline()
        if not line3: return
        
        # Используем map(int, ...) для быстрого преобразования всех чисел сразу
        values = list(map(int, (line1.strip() + ' ' + line2.strip() + ' ' + line3.strip()).split()))
        if len(values) < 3: return
        
        n, m, k = values[:3]

    except ValueError:
        return

    # Убеждаемся, что n <= m для упрощения логики (меняем местами при необходимости)
    if n > m:
        n, m = m, n

    counts = * k

    # --- 1. Функция для расчета суммы арифметической прогрессии для заданного цвета ---
    def sum_arithmetic_progression(start_d, end_d, k_colors, n_fixed_length=None):
        """
        Рассчитывает количество клеток каждого цвета в диапазоне диагоналей [start_d, end_d].
        Если n_fixed_length задано, используется постоянная длина, иначе - возрастающая/убывающая.
        """
        if start_d > end_d:
            return * k

        range_len = end_d - start_d + 1
        
        # Распределение количества диагоналей каждого цвета в этом диапазоне
        full_cycles = range_len // k_colors
        remaining = range_len % k_colors
        
        # Определяем стартовый цвет (0-индексированный)
        start_color = (start_d - 1) % k_colors

        result_counts = * k_colors

        for i in range(k_colors):
            # Цвет, который мы сейчас считаем (смещение от стартового цвета)
            current_color_index = (start_color + i) % k_colors
            
            # Количество диагоналей этого конкретного цвета в диапазоне
            num_diagonals_of_color = full_cycles + (1 if i < remaining else 0)
            
            if num_diagonals_of_color == 0:
                continue

            if n_fixed_length is not None:
                # Случай постоянной длины (Центральный "прямоугольник")
                result_counts[current_color_index] += num_diagonals_of_color * n_fixed_length
            else:
                # Случай переменной длины (Начальный/Конечный "треугольник")
                # Длина диагонали 'd' это либо 'd', либо 'n+m-d'.
                
                # Начальная длина для этого цвета в последовательности
                if start_d == 1: # Начальный треугольник
                     # Первая диагональ этого цвета имеет номер start_d + offset_to_color
                     # Длина равна этому номеру
                    first_d_of_color = start_d + (i if i >= (start_color) else (k_colors - start_color + i)) # Сложно считать смещение точно, проще через формулу длины.
                    
                    # Вместо сложных смещений, используем формулу суммы для всего диапазона, 
                    # это слишком сложно делить по цветам без цикла. 
                    # Вернемся к простому циклу по k.
                    pass
        
        # Так как требуется O(k), а не O(range_len), нужно использовать свойство арифметической прогрессии:
        # Мы можем рассчитать сумму длин для *каждого* цвета отдельно.
        
        for color_idx in range(k_colors):
            # Находим номер первой диагонали в диапазоне [start_d, end_d] для этого цвета
            # 'd' имеет цвет (d-1) % k
            
            # d-1 % k == color_idx
            # d % k == (color_idx + 1) % k
            
            # Находим первое 'd' >= start_d, которое удовлетворяет условию цвета
            first_d_of_color = start_d
            while (first_d_of_color - 1) % k_colors != color_idx:
                first_d_of_color += 1
            
            if first_d_of_color > end_d:
                continue
                
            # Находим последнее 'd' <= end_d для этого цвета
            last_d_of_color = end_d
            while (last_d_of_color - 1) % k_colors != color_idx:
                last_d_of_color -= 1
                
            if last_d_of_color < first_d_of_color:
                continue

            num_diag = (last_d_of_color - first_d_of_color) // k_colors + 1
            
            if n_fixed_length is not None:
                 # Постоянная длина
                result_counts[color_idx] += num_diag * n_fixed_length
            elif start_d == 1:
                # Начальный треугольник L(d) = d
                # Сумма прогрессии num_diag * (first_d_of_color + last_d_of_color) / 2
                result_counts[color_idx] += num_diag * (first_d_of_color + last_d_of_color) // 2
            else:
                # Конечный треугольник L(d) = n + m - d
                # L(first) = n+m-first, L(last) = n+m-last
                first_L = n + m - first_d_of_color
                last_L = n + m - last_d_of_color
                # Сумма прогрессии num_diag * (first_L + last_L) / 2
                result_counts[color_idx] += num_diag * (first_L + last_L) // 2
                
        return result_counts

    # 1. Начальный "треугольник" (диагонали 1 до n)
    # Длина L(d) = d
    counts = [counts[i] + sum_counts for i, sum_counts in enumerate(sum_arithmetic_progression(1, n, k))]
    
    # 2. Центральный "прямоугольник" (диагонали n+1 до m)
    # Длина L(d) = n
    if m >= n + 1:
         counts = [counts[i] + sum_counts for i, sum_counts in enumerate(sum_arithmetic_progression(n + 1, m, k, n_fixed_length=n))]

    # 3. Конечный "треугольник" (диагонали m+1 до n+m-1)
    # Длина L(d) = n + m - d
    if n + m - 1 >= m + 1:
        counts = [counts[i] + sum_counts for i, sum_counts in enumerate(sum_arithmetic_progression(m + 1, n + m - 1, k))]

    # Выводим результаты
    for i in range(k):
        print(counts[i])

if __name__ == "__main__":
    solve_final_optimized()

