import sys

def solve_optimized():
    """
    Рассчитывает количество клеток каждого цвета с использованием математического подхода.
    """
    try:
        # Чтение входных данных
        line1 = sys.stdin.readline()
        if not line1: return
        line2 = sys.stdin.readline()
        if not line2: return
        line3 = sys.stdin.readline()
        if not line3: return
        
        n_str, m_str, k_str = line1.strip().split() + line2.strip().split() + line3.strip().split()
        n = int(n_str)
        m = int(m_str)
        k = int(k_str)

    except (ValueError, IndexError):
        return

    # Убеждаемся, что n <= m для упрощения логики (меняем местами при необходимости)
    if n > m:
        n, m = m, n

    counts = * k

    # --- 1. Обработка начального "треугольника" (диагонали 1 до n) ---
    
    # В этом диапазоне длины диагоналей растут от 1 до n.
    # Мы можем распределить эти длины по цветам.
    
    # Полные циклы цветов (k * x)
    full_cycles = n // k
    remaining = n % k
    
    # Сумма длин в полном цикле цветов 1..k равна сумме арифметической прогрессии
    # (i + i+k + i+2k + ... до n)
    
    for color in range(k):
        # Количество диагоналей этого цвета в первых n диагоналях
        num_diagonals_of_color = full_cycles + (1 if color < remaining else 0)
        
        # Первая длина для этого цвета: (color + 1)
        # Последняя длина для этого цвета: (color + 1) + (num_diagonals_of_color - 1) * k
        last_length = (color + 1) + (num_diagonals_of_color - 1) * k

        # Сумма арифметической прогрессии: count * (first + last) / 2
        # Используем // 2 для целочисленного деления
        if num_diagonals_of_color > 0:
            counts[color] += num_diagonals_of_color * ((color + 1) + last_length) // 2
    
    # --- 2. Обработка центрального "прямоугольника" (диагонали n+1 до m) ---
    
    # В этом диапазоне длина каждой диагонали постоянна и равна n.
    # Количество таких диагоналей: (m - 1) - n + 1 + 1 = m - n + 1
    num_center_diagonals = m - n + 1
    
    for d in range(n, m + 1): # Номера диагоналей с n по m
        color_index = (d - 1) % k
        counts[color_index] += n
    
    # Примечание: Можно оптимизировать центральную часть еще больше, если m-n+1 очень большое,
    # рассчитав полные циклы k:
    
    # center_cycles = num_center_diagonals // k
    # center_remaining = num_center_diagonals % k
    # for color in range(k):
    #     counts[(n - 1 + color) % k] += center_cycles * n
    # for j in range(center_remaining):
    #     counts[(n - 1 + j) % k] += n

    # --- 3. Обработка конечного "треугольника" (диагонали m+1 до n+m-1) ---
    
    # Длины диагоналей убывают от n-1 до 1.
    # Мы можем переиспользовать логику из шага 1, но с обратным порядком цветов.

    # Количество диагоналей в этом "треугольнике" равно n - 1.
    
    for d in range(m + 1, n + m): # Номера диагоналей с m+1 по n+m-1
        color_index = (d - 1) % k
        # Длина диагонали L(d) = n + m - d
        counts[color_index] += (n + m - d)

    # Примечание: Этот цикл также можно оптимизировать математически, 
    # аналогично первому блоку, но используя обратный порядок длин (n-1 до 1).

    # Выводим результаты
    for i in range(k):
        print(counts[i])

if __name__ == "__main__":
    solve_optimized()
