import sys

def solve():
    """
    Рассчитывает количество клеток каждого цвета на дороге
    размером n x m с использованием k цветов.
    """
    
    # Считываем n, m, k из стандартного ввода (stdin)
    # Используем sys.stdin для обработки ввода построчно
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return
        n = int(line1.split()[0])
        
        line2 = sys.stdin.readline()
        if not line2:
            return
        m = int(line2.split()[0])
        
        line3 = sys.stdin.readline()
        if not line3:
            return
        k = int(line3.split()[0])

    except (ValueError, IndexError):
        # Если ввод не соответствует ожидаемому формату, прекращаем выполнение
        return

    # Массив для хранения количества клеток каждого цвета
    # Инициализируем нулями. Индексы от 0 до k-1 соответствуют цветам от 1 до k.
    counts = [0] * k

    # Общее количество диагоналей, которые пересекают сетку n x m
    # Диагонали нумеруются по сумме индексов (i + j - 1).
    # Номер первой диагонали = 1, номер последней = n + m - 1.
    total_diagonals = n + m - 1

    for d in range(1, total_diagonals + 1):
        # Определяем цвет текущей диагонали.
        # Цвет определяется по формуле (d - 1) % k + 1,
        # что в 0-индексированном массиве равно (d - 1) % k.
        color_index = (d - 1) % k
        
        # Определяем количество клеток в текущей диагонали, которые лежат
        # внутри сетки n x m.
        
        # Минимальная возможная длина диагонали d (если бы поле было бесконечным)
        # равна d, пока d не превысит n или m.
        # Максимальная возможная длина ограничена размерами n и m.
        
        # Длина диагонали L(d) равна:
        # min(d, n, m, n + m - d)
        
        length = min(d, n, m, n + m - d)
        
        # Добавляем длину текущей диагонали к счетчику соответствующего цвета
        counts[color_index] += length

    # Выводим результаты построчно
    for i in range(k):
        print(counts[i])

if __name__ == "__main__":
    solve()
