import sys

def solve_correct():
    """
    Решает задачу подсчета цветов клеток на дороге с корректной логикой
    и выводом каждого числа с новой строки.
    """
    try:
        # Читаем все входные данные и преобразуем их в список целых чисел.
        # Этот метод работает как при вводе с одной строки, так и с нескольких.
        data = list(map(int, sys.stdin.read().split()))

        if len(data) < 3:
            return

        # Правильное присваивание переменных
        n = data[0]
        m = data[1]
        k = data[2]

    except (IndexError, ValueError):
        # Если ввод некорректен
        return

    # Инициализация списка для хранения количества клеток каждого цвета (k цветов)
    # Используем 0-индексацию (цвета 0, 1, ..., k-1)
    counts = [0] * k

    # Общее количество клеток
    total_cells = n * m

    # Среднее количество клеток каждого цвета (целочисленное деление)
    avg_count = total_cells // k

    # Остаток от деления общего количества клеток
    remainder = total_cells % k

    # Базовое количество для каждого цвета
    for i in range(k):
        counts[i] = avg_count

    # Добавляем остаток к первым цветам
    # Цвет для клетки (1, 1) имеет индекс 0.
    for i in range(remainder):
        counts[i] += 1

    # Вывод результатов, каждое число в новой строке
    for count in counts:
        print(count)

if __name__ == "__main__":
    solve_correct()
