import sys

def solve_interactive():
    """
    Решает задачу, используя интерактивный ввод через input().
    """
    try:
        # Чтение трех чисел из стандартного ввода
        # Ожидаем, что числа могут быть на одной или нескольких строках.
        data = []
        while len(data) < 3:
            # Читаем строку, разделяем ее на числа и добавляем в общий список
            line_input = input().split()
            data.extend(map(int, line_input))

        n = data[0]
        m = data[1]
        k = data[2]

    except (IndexError, ValueError, EOFError):
        # Если ввод закончился раньше времени или был некорректен
        return

    # Инициализация списка для хранения количества клеток каждого цвета (k цветов)
    counts = [0] * k

    # Общее количество клеток
    total_cells = n * m

    # Среднее количество клеток каждого цвета (целочисленное деление)
    avg_count = total_cells // k

    # Остаток от деления общего количества клеток
    remainder = total_cells % k

    # Все цвета встречаются хотя бы avg_count раз
    for i in range(k):
        counts[i] = avg_count

    # Цвета с 1 по remainder встречаются на 1 раз чаще
    for i in range(remainder):
        counts[i] += 1

    # Вывод результатов, каждое число в новой строке
    for count in counts:
        print(count) # Функция print() автоматически добавляет перенос строки

if __name__ == "__main__":
    solve_interactive()
