import sys

def solve():
    try:
        # Чтение n, m и k из стандартного ввода
        lines = sys.stdin.read().split()
        if not lines or len(lines) < 3:
            return
        
        # Надежный способ получения трех чисел
        n = int(lines)
        m = int(lines)
        k = int(lines)
        
        # Инициализация списка счетчиков нулями (исправлено!)
        counts = * k

        # Итерация по всем возможным суммам индексов (диагоналям)
        # Этот цикл может быть медленным для больших N и M
        for s in range(1, n + m):
            # Вычисление количества клеток c для данной суммы s
            min_i = max(1, s - m + 1)
            max_i = min(n, s)
            c = max(0, max_i - min_i + 1)

            # Определение цвета
            color_index = (s - 1) % k

            # Добавление количества клеток к соответствующему счетчику
            counts[color_index] += c

        # Вывод результатов в отдельных строках
        for count in counts:
            print(count)
            
    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve()
