
import sys

def read_ints():
    """
    Генератор для чтения целых чисел из стандартного ввода,
    по одному числу за раз, независимо от того, находятся ли они
    на одной строке или на разных строках.
    """
    for line in sys.stdin:
        for x in line.split():
            yield int(x)
    return

def solve():
    """
    Решает задачу подсчета количества клеток каждого цвета.
    """
    try:
        # Инициализация генератора для чтения чисел
        reader = read_ints()

        # Чтение n, m, k по очереди
        try:
            n = next(reader)
            m = next(reader)
            k = next(reader)
        except StopIteration:
            # Если чисел не хватает, просто завершаем работу
            return

        # Для оптимизации и упрощения логики считаем, что n <= m
        if n > m:
            n, m = m, n

        # Инициализация списка счетчиков для k цветов
        # В Python int автоматически обрабатывает большие числа (64-бит)
        counts =[0] * k

        # Перебор всех диагоналей (от 0 до n + m - 2)
        for d in range(n + m - 1):
            color_index = d % k
            
            # Определение длины текущей диагонали
            if d < n:
                length = d + 1
            elif d >= m:
                length = n + m - 1 - d
            else:
                length = n
                
            counts[color_index] += length

        # Вывод результатов в требуемом формате (числа через пробел)
        print(*(counts))

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve()
