import sys

# Устанавливаем высокую точность для целочисленных операций
# (Хотя в Python 3 это обычно не требуется, на всякий случай)
sys.set_int_max_str_digits(200000000)

def solve_final_optimized():
    """
    Рассчитывает количество клеток каждого цвета полностью математически и без циклов по N, M.
    """
    try:
        # Чтение входных данных из stdin
        line1 = sys.stdin.readline()
        if not line1: return
        line2 = sys.stdin.readline()
        if not line2: return
        line3 = sys.stdin.readline()
        if not line3: return
        
        # Объединяем строки и считываем все числа сразу
        values = list(map(int, (line1.strip() + ' ' + line2.strip() + ' ' + line3.strip()).split()))
        if len(values) < 3: return
        
        n, m, k = values[:3]

    except ValueError:
        return

    # Убеждаемся, что n <= m для упрощения логики (меняем местами при необходимости)
    if n > m:
        n, m = m, n

    # Итоговые счетчики для k цветов (0-индексированные)
    counts = [0] * k

    # --- Функция для расчета сумм для диапазона ---
    def calculate_range_sums(start_d, end_d, k_colors, is_central=False):
        if start_d > end_d:
            return [0] * k_colors

        result_counts = [0] * k_colors
        
        # Используем математику для расчета сумм по каждому цвету
        for c in range(k_colors):
            # Находим первый номер диагонали 'd' в диапазоне [start_d, end_d] для цвета 'c'.
            # Условие цвета: (d - 1) % k == c
            
            # d_start_offset = (start_d - 1) % k_colors
            # first_d_of_color = start_d + (c - d_start_offset + k_colors) % k_colors
            
            # Более простой поиск первого d (так как k<=5, цикл быстрый)
            first_d_of_color = start_d
            while (first_d_of_color - 1) % k_colors != c:
                first_d_of_color += 1

            if first_d_of_color > end_d:
                continue

            # Находим последний номер диагонали 'd' в диапазоне [start_d, end_d] для цвета 'c'.
            last_d_of_color = end_d
            while (last_d_of_color - 1) % k_colors != c:
                last_d_of_color -= 1
            
            if last_d_of_color < first_d_of_color:
                continue
                
            num_diag = (last_d_of_color - first_d_of_color) // k_colors + 1
            
            if is_central:
                # Постоянная длина n
                result_counts[c] += num_diag * n
            elif start_d == 1:
                # Начальный треугольник L(d) = d
                result_counts[c] += num_diag * (first_d_of_color + last_d_of_color) // 2
            else:
                # Конечный треугольник L(d) = n + m - d
                first_L = n + m - first_d_of_color
                last_L = n + m - last_d_of_color
                result_counts[c] += num_diag * (first_L + last_L) // 2
                
        return result_counts

    # 1. Начальный "треугольник" (диагонали 1 до n)
    sums_t1 = calculate_range_sums(1, n, k)
    for i in range(k):
        counts[i] += sums_t1[i]
    
    # 2. Центральный "прямоугольник" (диагонали n+1 до m)
    if m >= n + 1:
        sums_center = calculate_range_sums(n + 1, m, k, is_central=True)
        for i in range(k):
            counts[i] += sums_center[i]

    # 3. Конечный "треугольник" (диагонали m+1 до n+m-1)
    if n + m - 1 >= m + 1:
        sums_t2 = calculate_range_sums(m + 1, n + m - 1, k)
        for i in range(k):
            counts[i] += sums_t2[i]

    # Выводим результаты
    print(*(counts))

if __name__ == "__main__":
    solve_final_optimized()
