import sys

# Устанавливаем высокую точность для целочисленных операций
sys.set_int_max_str_digits(200000000)

def solve_final_optimized():
    """
    Рассчитывает количество клеток каждого цвета полностью математически и без циклов по N, M.
    """
    try:
        # Чтение входных данных
        line1 = sys.stdin.readline()
        if not line1: return
        line2 = sys.stdin.readline()
        if not line2: return
        line3 = sys.stdin.readline()
        if not line3: return
        
        values = list(map(int, (line1.strip() + ' ' + line2.strip() + ' ' + line3.strip()).split()))
        if len(values) < 3: return
        
        n, m, k = values[:3]

    except ValueError:
        return

    # Убеждаемся, что n <= m для упрощения логики
    if n > m:
        n, m = m, n

    # Итоговые счетчики для k цветов (0-индексированные)
    counts = * k

    # 1. Расчет для начального "треугольника" (диагонали 1 до n, длины L(d) = d)
    # Диапазон длин: 1, 2, ..., n
    
    # Для каждого цвета 'c' (от 0 до k-1)
    for c in range(k):
        # Находим первый номер диагонали 'd' в диапазоне [1, n], который имеет цвет 'c'.
        # Условие цвета: (d - 1) % k == c => d % k == (c + 1) % k
        # Первый d >= 1:
        first_d = 1
        while (first_d - 1) % k != c:
            first_d += 1
        
        if first_d > n:
            continue

        # Находим последний номер диагонали 'd' в диапазоне [1, n] для цвета 'c'.
        last_d = n
        while (last_d - 1) % k != c:
            last_d -= 1
        
        if last_d < first_d:
            continue
            
        # Количество диагоналей данного цвета
        num_diag = (last_d - first_d) // k + 1
        
        # Сумма длин (L(d)=d) по арифметической прогрессии: count * (first + last) / 2
        counts[c] += num_diag * (first_d + last_d) // 2

    # 2. Расчет для центрального "прямоугольника" (диагонали n+1 до m, длины L(d) = n)
    if m >= n + 1:
        num_center_diagonals = m - n
        
        # Распределение общего числа диагоналей по k цветам
        full_cycles = num_center_diagonals // k
        remaining = num_center_diagonals % k
        
        # Определяем стартовый цвет для этого диапазона (цвет диагонали n+1)
        start_color = (n + 1 - 1) % k # (n % k)

        for i in range(k):
            # Цвет, который мы сейчас считаем, с учетом стартового смещения
            current_color_index = (start_color + i) % k
            
            # Количество диагоналей этого цвета в центральной части
            count_of_this_color = full_cycles + (1 if i < remaining else 0)
            
            # Длина каждой диагонали здесь равна n
            counts[current_color_index] += count_of_this_color * n

    # 3. Расчет для конечного "треугольника" (диагонали m+1 до n+m-1, длины L(d) = n+m-d)
    # Диапазон длин: n-1, n-2, ..., 1

    if n + m - 1 >= m + 1:
        # Для каждого цвета 'c' (от 0 до k-1)
        for c in range(k):
            # Находим первый номер диагонали 'd' в диапазоне [m+1, n+m-1] для цвета 'c'.
            first_d = m + 1
            while (first_d - 1) % k != c:
                first_d += 1
            
            if first_d > n + m - 1:
                continue

            # Находим последний номер диагонали 'd' в диапазоне [m+1, n+m-1] для цвета 'c'.
            last_d = n + m - 1
            while (last_d - 1) % k != c:
                last_d -= 1
            
            if last_d < first_d:
                continue
                
            # Количество диагоналей данного цвета
            num_diag = (last_d - first_d) // k + 1
            
            # Длина L(d) = n + m - d
            # Первая длина: n + m - first_d
            # Последняя длина: n + m - last_d
            first_L = n + m - first_d
            last_L = n + m - last_d
            
            # Сумма длин по арифметической прогрессии: count * (first_L + last_L) / 2
            counts[c] += num_diag * (first_L + last_L) // 2

    # Выводим результаты
    for i in range(k):
        print(counts[i])

if __name__ == "__main__":
    solve_final_optimized()
