def count_magic_numbers(n):
    """
    Возвращает количество магических чисел от 1 до n включительно.
    Магическое число: делится на 7 ИЛИ оканчивается на 7.
    """
    # Количество чисел, делящихся на 7
    div_by_7 = n // 7

    # Количество чисел, оканчивающихся на 7
    ends_with_7 = (n // 10) + (1 if n % 10 >= 7 else 0)

    # Количество чисел, удовлетворяющих обоим условиям
    both = n // 70 + (1 if n % 70 >= 7 else 0)

    # По принципу включения-исключения
    return div_by_7 + ends_with_7 - both


def find_kth_magic_number(k):
    """
    Находит k-е магическое число с помощью бинарного поиска.
    """
    left, right = 1, 10 ** 20  # Правая граница достаточна для k ≤ 10^17

    while left < right:
        mid = (left + right) // 2
        count = count_magic_numbers(mid)

        if count >= k:
            right = mid
        else:
            left = mid + 1

    return left


def main():
    k = int(input().strip())
    result = find_kth_magic_number(k)
    print(result)


if __name__ == "__main__":
    main()