#include <iostream>
#include <vector>
#include <algorithm>
#include <limits>

using namespace std;
using ll = long long;

struct Rect {
    int x1, y1, x2, y2;
};

bool solve_one_case(const vector<Rect>& rects) {
    int n = rects.size();
    if (n == 1) return true;
    int common_x_min = 0, common_x_max = 1e6;
    for (auto& r : rects) {
        common_x_min = max(common_x_min, r.x1);
        common_x_max = min(common_x_max, r.x2);
    }
    if (common_x_min <= common_x_max) return true;
    int common_y_min = 0, common_y_max = 1e6;
    for (auto& r : rects) {
        common_y_min = max(common_y_min, r.y1);
        common_y_max = min(common_y_max, r.y2);
    }
    if (common_y_min <= common_y_max) return true;
    {
        ll max_m = numeric_limits<ll>::min();
        ll min_M = numeric_limits<ll>::max();
        for (auto& r : rects) {
            ll M = (ll)r.x2 + (ll)r.y2;
            ll m = (ll)r.x1 + (ll)r.y1;
            max_m = max(max_m, m);
            min_M = min(min_M, M);
        }
        if (max_m <= min_M) return true;
    }
    {
        ll max_m = numeric_limits<ll>::min();
        ll min_M = numeric_limits<ll>::max();
        for (auto& r : rects) {
            ll M = (ll)r.x1 + (ll)r.y2;
            ll m = (ll)r.x2 + (ll)r.y1;
            max_m = max(max_m, m);
            min_M = min(min_M, M);
        }
        if (max_m <= min_M) return true;
    }
    {
        ll max_m = numeric_limits<ll>::min();
        ll min_M = numeric_limits<ll>::max();
        for (auto& r : rects) {
            ll M = (ll)r.x1 + (ll)r.y1;
            ll m = (ll)r.x2 + (ll)r.y2;
            max_m = max(max_m, m);
            min_M = min(min_M, M);
        }
        if (max_m <= min_M) return true;
    }
    {
        ll max_m = numeric_limits<ll>::min();
        ll min_M = numeric_limits<ll>::max();
        for (auto& r : rects) {
            ll M = (ll)r.x2 + (ll)r.y1;
            ll m = (ll)r.x1 + (ll)r.y2;
            max_m = max(max_m, m);
            min_M = min(min_M, M);
        }
        if (max_m <= min_M) return true;
    }

    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--) {
        int n;
        cin >> n;
        vector<Rect> rects(n);
        for (int i = 0; i < n; i++) {
            cin >> rects[i].x1 >> rects[i].y1 >> rects[i].x2 >> rects[i].y2;
        }
        cout << (solve_one_case(rects) ? "YES" : "NO") << "\n";
    }

    return 0;
}