#include <iostream>
#include <algorithm>
using namespace std;
using ll = long long;

ll count_up_to(ll N) {
    if (N < 7) return 0;
    ll div7 = N / 7;
    ll end7 = (N - 7) / 10 + 1;
    ll both = (N - 7) / 70 + 1;
    return div7 + end7 - both;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    ll k;
    cin >> k;

    ll left = 1, right = 1e18;
    while (left < right) {
        ll mid = left + (right - left) / 2;
        if (count_up_to(mid) >= k) {
            right = mid;
        }
        else {
            left = mid + 1;
        }
    }

    cout << left << "\n";

    return 0;
}