﻿const
  MAX = 1000000;

var
  is_odd_power: array[1..MAX] of boolean;
  m, l, r, i, j, cnt, start: integer;
  
procedure precalculate;
var
  i, j: integer;
begin
  // Инициализация массива
  for i := 1 to MAX do
    is_odd_power[i] := true;
    
  // Проверка для каждого простого числа
  for i := 2 to MAX do begin
    if is_odd_power[i] then begin
      // Проверяем степени
      j := i * i;
      while j <= MAX do begin
        // Если степень чётная, отмечаем как false
        if (j mod (i * i) = 0) then
          is_odd_power[j] := false;
        j := j * i;
      end;
    end;
  end;
end;

begin
  precalculate();
  
  readln(m);
  readln(l, r);
  
  cnt := 0;
  start := -1;
  
  // Поиск последовательности
  for i := l to r do begin
    if is_odd_power[i] then begin
      if cnt = 0 then
        start := i;
      inc(cnt);
      if cnt = m then break;
    end else begin
      cnt := 0;
      start := -1;
    end;
  end;
  
  // Вывод результата
  if cnt = m then begin
    for i := start to start + m - 1 do
      write(i, ' ');
  end else
    writeln(-1);
end.
