﻿program MagicSeven;

var
  k, left, right, mid: Int64;

function CountMagicNumbers(x: Int64): Int64;
var
  div7, ends7, both: Int64;
begin
  // Числа, делящиеся на 7
  div7 := x div 7;
  // Числа, оканчивающиеся на 7 (каждая 10-я позиция, начиная с 7)
  ends7 := (x + 3) div 10;
  // Числа, делящиеся на 7 и оканчивающиеся на 7 (пересечение)
  both := 0;
  var i := 7;
  while i <= x do
  begin
    if (i mod 10 = 7) then
      Inc(both);
    i := i + 70; // шаг 70 сохраняет последнюю цифру 7
  end;
  Result := div7 + ends7 - both; // объединение с вычитанием пересечения
end;

begin
  ReadLn(k); // Ввод k — номер магического числа

  left := 1;
  right := 1000000000000000000; // Верхняя граница (достаточно большая для k ≤ 10^17)

  // Бинарный поиск k-го магического числа
  while left < right do
  begin
    mid := (left + right) div 2;
    if CountMagicNumbers(mid) < k then
      left := mid + 1
    else
      right := mid;
  end;

  WriteLn(left); // Вывод k-го магического числа
end.
