﻿program MagicSeven;

var
  k, left, right, mid, count: int64;

function CountMagicNumbers(x: int64): int64;
var
  div7, ends7, both: int64;
begin
  // Числа, делящиеся на 7
  div7 := x div 7;
  // Числа, оканчивающиеся на 7
  ends7 := (x + 3) div 10; // округление вверх для последней цифры 7
  // Числа, делящиеся на 7 и оканчивающиеся на 7 (пересечение)
  both := 0;
  var i := 7;
  while i <= x do
  begin
    if (i mod 10 = 7) then Inc(both);
    i := i + 70; // шаг 70, чтобы сохранить последнюю цифру 7
  end;
  Result := div7 + ends7 - both; // объединение с вычитанием пересечения
end;

begin
  readln(k); // Ввод k
  left := 1;
  right := 1000000000000000000; // Верхняя граница (достаточно большая)

  while left < right do
  begin
    mid := (left + right) div 2;
    count := CountMagicNumbers(mid);
    if count < k then
      left := mid + 1
    else
      right := mid;
  end;

  writeln(left); // Вывод k-го магического числа
end.
