﻿program ХомячьяРаскраска;

begin
  // Считываем входные данные из стандартного потока ввода
  var n, m, k: int64;
  Readln(n, m, k);

  // Инициализируем массив для подсчёта клеток каждого цвета (k ≤ 5)
  var count: array[1..5] of int64;
  for var i := 1 to k do
    count[i] := 0; // обнуляем счётчики

  // Перебираем все диагонали (от 1 до n + m - 1)
  for var diag := 1 to n + m - 1 do
  begin
    var cellsInDiag: int64; // количество клеток на диагонали

    // Вычисляем количество клеток на текущей диагонали
    if diag <= Min(n, m) then
      cellsInDiag := diag
    else if diag <= Max(n, m) then
      cellsInDiag := Min(n, m)
    else
      cellsInDiag := n + m - diag;

    // Определяем цвет диагонали (циклически по k)
    var color := (cellsInDiag - 1) mod k + 1;

    // Увеличиваем счётчик для данного цвета
    count[color] += cellsInDiag;
  end;

  // Выводим результаты в стандартный поток вывода (по одному числу в строке)
  for var i := 1 to k do
    Writeln(count[i]);
end.
