﻿program ХомячьяРаскраска;

begin
  // Считываем входные данные: n, m — размеры дороги, k — количество цветов
  var n, m, k: int64;
  Readln(n, m, k);

  // Массив для хранения количества клеток каждого цвета (индексы 1..k)
  var count: array[1..5] of int64; // k ≤ 5 по условию

  // Инициализируем массив нулями
  for var i := 1 to k do
    count[i] := 0;

  // Проходим по всем диагоналям (от 1 до n + m - 1)
  for var diag := 1 to n + m - 1 do
  begin
    var cellsInDiag: int64; // количество клеток на текущей диагонали

    // Вычисляем количество клеток на диагонали
    if diag <= Min(n, m) then
      cellsInDiag := diag
    else if diag <= Max(n, m) then
      cellsInDiag := Min(n, m)
    else
      cellsInDiag := n + m - diag;

    // Определяем цвет диагонали (с учётом цикличности по k)
    var color := (cellsInDiag - 1) mod k + 1;

    // Увеличиваем счётчик для этого цвета
    count[color] += cellsInDiag;
  end;

  // Выводим результаты: количество клеток для каждого цвета
  for var i := 1 to k do
    Writeln(count[i]);
end.
