﻿program ХомячьяРаскраска;
var
  n, m, k: int64; // размеры дороги и количество цветов

begin
  // Считываем входные данные
  readln(n, m, k);

  // Массив для подсчёта клеток каждого цвета (k ≤ 5)
  var count: array[1..5] of int64;

  // Инициализируем массив подсчёта нулями
  for var i := 1 to k do
    count[i] := 0;

  // Проходим по всем диагоналям (от 1 до n + m - 1)
  for var diag := 1 to n + m - 1 do
  begin
    var color: int64; // переменная для хранения цвета текущей диагонали

    // Определяем количество клеток на текущей диагонали
    if diag <= min(n, m) then
      color := diag
    else if diag <= max(n, m) then
      color := min(n, m)
    else
      color := n + m - diag;

    // Определяем цвет текущей диагонали (с учётом цикличности)
    color := (color - 1) mod k + 1;

    // Увеличиваем счётчик для соответствующего цвета
    count[color] := count[color] + color;
  end;

  // Выводим результаты (количество клеток для каждого цвета)
  for var i := 1 to k do
    writeln(count[i]);
end.
