﻿program ХомячьяРаскраска;
var
  n, m, k: int64; // размеры дороги и количество цветов
  i, diag, color: int64; // переменные для циклов и расчётов
  count: array[1..5] of int64; // массив для подсчёта клеток каждого цвета

begin
  // Считываем входные данные
  readln(n, m, k);

  // Инициализируем массив подсчёта нулями
  for i := 1 to k do
    count[i] := 0;

  // Проходим по всем диагоналям
  for diag := 1 to n + m - 1 do
  begin
    // Определяем количество клеток на текущей диагонали
    if diag <= min(n, m) then
      color := diag
    else if diag <= max(n, m) then
      color := min(n, m)
    else
      color := n + m - diag;

    // Определяем цвет текущей диагонали (с учётом цикличности)
    color := (color - 1) mod k + 1;

    // Увеличиваем счётчик для соответствующего цвета
    count[color] := count[color] + color;
  end;

  // Выводим результаты
  for i := 1 to k do
    writeln(count[i]);
end.
