﻿program Хомячья_раскраска;
var
  n, m, k: Int64;
  colors: array[1..5] of Int64; // массив для подсчёта клеток по цветам
  d, len, color: Int64;
  min_nm, max_nm: Int64;
  i: Integer;
begin
  // Чтение входных данных
  ReadLn(n, m, k);
  
  // Быстрая инициализация массива через цикл
  for i := Low(colors) to High(colors) do
    colors[i] := 0;
  
  // Вычисление минимальных и максимальных значений
  min_nm := Min(n, m);
  max_nm := Max(n, m);
  
  // Оптимизированный цикл по диагоналям
  for d := 1 to n + m - 1 do
  begin
    // Оптимизированное вычисление длины диагонали
    if d <= min_nm then
      len := d
    else if d > max_nm then
      len := n + m - d
    else
      len := min_nm;
      
    // Определение цвета диагонали
    color := ((d - 1) mod k) + 1;
    
    // Увеличение счётчика
    Inc(colors[color], len);
  end;
  
  // Вывод результатов
  for i := 1 to k do
    WriteLn(colors[i]);
end.
