﻿var
  n, m, k: int64;
  colors: array[1..5] of int64;
  min_val, max_val, sum, full_cycles: int64;
  i: integer;
begin
  // Считываем входные данные
  readln(n, m, k);
  
  // Определяем минимальное и максимальное значение
  if n < m then begin
    min_val := n;
    max_val := m;
  end else begin
    min_val := m;
    max_val := n;
  end;
  
  // Обнуляем массив для подсчета цветов
  for i := 1 to k do
    colors[i] := 0;
  
  // Вычисляем общее количество диагоналей
  sum := n + m - 1;
  
  // Вычисляем количество полных циклов
  full_cycles := sum div k;
  
  // Оптимизированный расчет для полных циклов
  for i := 1 to k do begin
    // Добавляем количество полных циклов для каждого цвета
    colors[i] := full_cycles;
  end;
  
  // Обрабатываем оставшиеся диагонали
  for i := 1 to sum mod k do begin
    colors[i] := colors[i] + 1;
  end;
  
  // Вычисляем количество клеток для каждой диагонали
  // Первая часть (до min_val)
  for i := 1 to min_val do begin
    colors[i mod k + 1] := colors[i mod k + 1] + i;
  end;
  
  // Средняя часть (между min_val и max_val)
  for i := min_val + 1 to max_val do begin
    colors[i mod k + 1] := colors[i mod k + 1] + min_val;
  end;
  
  // Последняя часть (после max_val)
  for i := max_val + 1 to sum do begin
    colors[(sum - i + 1) mod k + 1] := colors[(sum - i + 1) mod k + 1] + (sum - i + 1);
  end;
  
  // Выводим результаты
  for i := 1 to k do
    writeln(colors[i]);
end.
