﻿program HamsterBinarySecrets;

const
  MOD = 1000000007;
  MAX_DEC_LEN = 30000;
  MAX_BIN_LEN = 100000; // ~ log2(10^30000) ≈ 100000
  MAX_K = 100000;

var
  n, K: longint;
  R_dec: array[1..MAX_DEC_LEN] of byte;
  R_bin: array[0..MAX_BIN_LEN-1] of byte;
  bin_len: longint;

  // DP-таблица: dp[pos][mod][tight]
  // Используем два слоя для экономии памяти
  dp_curr: array[0..MAX_K-1, 0..1] of int64;
  dp_next: array[0..MAX_K-1, 0..1] of int64;

procedure ReadInput;
var
  i: longint;
  c: char;
begin
  readln(n, K);
  for i := 1 to n do
  begin
    read(c);
    R_dec[i] := ord(c) - ord('0');
  end;
end;

function DecimalToBinary: longint;
var
  digits: array[1..MAX_DEC_LEN] of longint;
  new_digits: array[1..MAX_DEC_LEN] of longint;
  d_len, nd_len, i, rem: longint;
  num: longint;
begin
  if (n = 1) and (R_dec[1] = 0) then
  begin
    R_bin[0] := 0;
    exit(1);
  end;

  d_len := n;
  for i := 1 to d_len do
    digits[i] := R_dec[i];

  bin_len := 0;

  while d_len > 0 do
  begin
    rem := 0;
    nd_len := 0;

    for i := 1 to d_len do
    begin
      num := rem * 10 + digits[i];
      new_digits[nd_len + 1] := num div 2;
      rem := num mod 2;

      if (nd_len = 0) and (new_digits[1] = 0) then
        continue // пропускаем ведущий ноль
      else
        nd_len := nd_len + 1;
    end;

    R_bin[bin_len] := rem;
    bin_len := bin_len + 1;

    d_len := nd_len;
    for i := 1 to nd_len do
      digits[i] := new_digits[i];
  end;

  // Разворачиваем массив (от старшего бита к младшему)
  for i := 0 to bin_len - 1 do
    R_bin[i] := R_bin[bin_len - 1 - i];

  exit(bin_len);
end;

function Solve: int64;
var
  pos, mod_val, tight, bit, new_mod, new_tight: longint;
  count: int64;
begin
  // Инициализируем DP
  for mod_val := 0 to K - 1 do
    for tight := 0 to 1 do
      dp_curr[mod_val, tight] := 0;

  dp_curr[0, 1] := 1; // начальное состояние: pos = bin_len, mod = 0, tight = 1

  for pos := bin_len - 1 downto 0 do
  begin
    // Очищаем следующий слой
    for mod_val := 0 to K - 1 do
      for tight := 0 to 1 do
        dp_next[mod_val, tight] := 0;

    // Переходим от текущего слоя к следующему
    for mod_val := 0 to K - 1 do
      for tight := 0 to 1 do
      begin
        if dp_curr[mod_val, tight] = 0 then
          continue;

        count := dp_curr[mod_val, tight];

        // Перебираем возможные биты: 0 и 1
        for bit := 0 to 1 do
        begin
          // Если tight=1, нельзя ставить бит больше, чем в R_bin
          if (tight = 1) and (bit > R_bin[pos]) then
            continue;

          new_tight := 0;
          if (tight = 1) and (bit = R_bin[pos]) then
            new_tight := 1;

          new_mod := (mod_val + bit) mod K;

          dp_next[new_mod, new_tight] :=
            (dp_next[new_mod, new_tight] + count) mod MOD;
        end;
      end;

    // Переходим к следующему слою
    for mod_val := 0 to K - 1 do
      for tight := 0 to 1 do
        dp_curr[mod_val, tight] := dp_next[mod_val, tight];
  end;

  // Ответ: сумма состояний, где mod = 0 (все биты обработаны)
  result := (dp_curr[0, 0] + dp_curr[0, 1]) mod MOD;
end;

begin
  ReadInput;
  bin_len := DecimalToBinary;
  writeln(Solve);
end.

