﻿program OddPowerNumbers;

const
  MAX_R = 1000000;

var
  m, l, r, i, start, count: longint;
  isOddPower: array[1..MAX_R] of boolean;

// Проверяет, является ли число нечётно-степенным
function IsOddPowerNum(n: longint): boolean;
var
  d, exp, temp: longint;
begin
  temp := n;
  d := 2;
  
  // Проверяем делители до sqrt(n)
  while d * d <= temp do
  begin
    if temp mod d = 0 then
    begin
      exp := 0;
      // Считаем степень простого делителя d
      while temp mod d = 0 do
      begin
        temp := temp div d;
        exp := exp + 1;
      end;
      
      // Если степень чётная — число не подходит
      if exp mod 2 = 0 then
      begin
        Result := false;
        exit;
      end;
    end;
    d := d + 1;
  end;
  
  // Если после деления осталось число > 1, это простой делитель в степени 1 (нечётная)
  if temp > 1 then
  begin
    Result := true;
    exit;
  end;
  
  Result := true;
end;

begin
  // Ввод данных
  readln(m);
  readln(l, r);
  
  // Предварительно вычисляем свойства чисел от 1 до r
  for i := 1 to r do
    isOddPower[i] := IsOddPowerNum(i);
  
  // Ищем первую последовательность из m подряд идущих нечётно-степенных чисел
  start := -1;
  count := 0;
  
  for i := l to r do
  begin
    if isOddPower[i] then
      count := count + 1
    else
      count := 0; // Сброс счётчика при нарушении последовательности
    
    // Если нашли нужную последовательность
    if count = m then
    begin
      start := i - m + 1;
      break;
    end;
  end;
  
  // Вывод результата
  if start = -1 then
    writeln(-1)
  else
  begin
    for i := start to start + m - 1 do
    begin
      if i > start then
        write(' ');
      write(i);
    end;
    writeln;
  end;
end.
