﻿program HamsterColoring;

{$MODE FPC}

var
  n, m, k: int64;
  colors: array[1..5] of int64;
  minDim, maxDim, totalDiags, len, fullCycles, rem, startColor: int64;
  i, c: longint;

function getColor(diagNum: int64): longint;
begin
  Result := (diagNum - 1) mod k + 1;
end;

begin
  // Чтение входных данных
  readln(n, m, k);
  
  // Инициализация массива цветов
  for i := 1 to k do
    colors[i] := 0;
  
  // Определяем минимальную и максимальную размерность
  if n < m then
  begin
    minDim := n;
    maxDim := m;
  end
  else
  begin
    minDim := m;
    maxDim := n;
  end;
  
  totalDiags := n + m - 1;
  
  // 1. Растущая часть: диагонали длины от 1 до minDim-1
  for len := 1 to minDim - 1 do
  begin
    fullCycles := len div k;
    rem := len mod k;
    startColor := getColor(len);
    
    // Вклад полных циклов
    for c := 1 to k do
      colors[c] := colors[c] + fullCycles * len;
    
    // Вклад остатка
    for c := 0 to rem - 1 do
      colors[(startColor + c - 1) mod k + 1] :=
        colors[(startColor + c - 1) mod k + 1] + len;
  end;
  
  // 2. Плато: диагонали длины minDim
  len := minDim;
  fullCycles := (maxDim - minDim + 1) div k;
  rem := (maxDim - minDim + 1) mod k;
  startColor := getColor(minDim + 1);
  
  // Вклад полных циклов
  for c := 1 to k do
    colors[c] := colors[c] + fullCycles * len;
  
  // Вклад остатка
  for c := 0 to rem - 1 do
    colors[(startColor + c - 1) mod k + 1] :=
      colors[(startColor + c - 1) mod k + 1] + len;
  
  // 3. Убывающая часть: диагонали длины от minDim-1 до 1
  for len := minDim - 1 downto 1 do
  begin
    // Номер первой диагонали этой длины
    startColor := getColor(totalDiags - len + 1);
    fullCycles := len div k;
    rem := len mod k;
    
    // Вклад полных циклов
    for c := 1 to k do
      colors[c] := colors[c] + fullCycles * len;
    
    // Вклад остатка
    for c := 0 to rem - 1 do
      colors[(startColor + c - 1) mod k + 1] :=
        colors[(startColor + c - 1) mod k + 1] + len;
  end;
  
  // Вывод результатов
  for i := 1 to k do
    writeln(colors[i]);
end.
