﻿program HamsterColoring;

var
  n, m, k, L, D, len, cnt, fullCycles, rem, startColor: int64;
  colors: array[1..5] of int64;
  i, color: longint;

begin
  readln(n, m, k);

  // Инициализация
  for color := 1 to k do
    colors[color] := 0;


  L := min(n, m);
  D := abs(n - m) + 1;


  // Зона роста: длины 1..L-1
  for len := 1 to L - 1 do
  begin
    cnt := len;  // число клеток в диагонали длины len
    startColor := (len - 1) mod k + 1;  // цвет первой диагонали этой длины

    // Сколько полных циклов k в cnt диагоналях этой длины?
    fullCycles := cnt div k;
    rem := cnt mod k;

    // Вклад полных циклов
    for color := 1 to k do
      colors[color] := colors[color] + fullCycles * len;


    // Вклад остатка
    for i := 0 to rem - 1 do
    begin
      color := (startColor + i - 1) mod k + 1;
      colors[color] := colors[color] + len;
    end;
  end;

  // Зона плато: D диагоналей длины L
  cnt := D;
  startColor := L mod k + 1;  // первая диагональ плато: номер L+1 → цвет (L mod k)+1

  fullCycles := cnt div k;
  rem := cnt mod k;

  for color := 1 to k do
    colors[color] := colors[color] + fullCycles * L;


  for i := 0 to rem - 1 do
  begin
    color := (startColor + i - 1) mod k + 1;
    colors[color] := colors[color] + L;
  end;

  // Зона спада: длины L-1..1
  for len := L - 1 downto 1 do
  begin
    cnt := len;
    startColor := (n + m - len) mod k + 1;  // номер первой диагонали спада: n+m-len

    fullCycles := cnt div k;
    rem := cnt mod k;

    for color := 1 to k do
      colors[color] := colors[color] + fullCycles * len;

    for i := 0 to rem - 1 do
    begin
      color := (startColor + i - 1) mod k + 1;
      colors[color] := colors[color] + len;
    end;
  end;

  // Вывод
  for color := 1 to k do
    writeln(colors[color]);
end.
