﻿program HamsterColoring;

var
  n, m, k: int64;
  colors: array[1..5] of int64;
  diagLen, startDiag, endDiag, diag, color: longint;
  total: int64;

begin
  // Ввод данных
  readln(n, m, k);

  // Инициализация массива цветов
  for color := 1 to k do
    colors[color] := 0;

  // Определяем диапазон диагоналей
  startDiag := 1;
  endDiag := n + m - 1;

  // Перебираем все диагонали
  for diag := startDiag to endDiag do
  begin
    // Вычисляем длину диагонали
    if diag <= n then
    begin
      if diag <= m then
        diagLen := diag
      else
        diagLen := m;
    end
    else
    begin
      if (n + m - diag) <= m then
        diagLen := n + m - diag
      else
        diagLen := m;
    end;

    // Определяем цвет диагонали (1..k)
    color := (diag - 1) mod k + 1;

    // Добавляем длину диагонали к соответствующему цвету
    colors[color] := colors[color] + diagLen;
  end;

  // Вывод результатов
  for color := 1 to k do
    writeln(colors[color]);
end.
