﻿program HamsterColoring;

var
  n, m, k: int64;
  colors: array[1..5] of int64;
  diag, start_diag, end_diag, len, color: longint;
  total: int64;

begin
  // Ввод данных
  readln(n, m, k);

  // Инициализируем массив цветов нулями
  for color := 1 to k do
    colors[color] := 0;

  // Определяем диапазон диагоналей
  start_diag := 2;          // первая диагональ (1,1)
  end_diag := n + m;        // последняя диагональ

  // Перебираем все диагонали
  for diag := start_diag to end_diag do
  begin
    // Вычисляем длину диагонали
    if diag <= n + 1 then
    begin
      if diag <= m + 1 then
        len := diag - 1
      else
        len := m;
    end
    else
    begin
      if diag >= n + m then
        len := 1
      else if diag > m + n then
        len := 0
      else
      begin
        if diag - n <= m then
          len := n + m - diag + 1
        else
          len := m;
      end;
    end;

    // Альтернативный (более простой) способ вычисления длины диагонали
    len := 0;
    if (diag >= 2) and (diag <= n + m) then
    begin
      // Нижняя граница по строкам: max(1, diag - m)
      // Верхняя граница по строкам: min(n, diag - 1)
      len := min(n, diag - 1) - max(1, diag - m) + 1;
      if len < 0 then len := 0;
    end;

    if len <= 0 then
      continue;

    // Определяем цвет диагонали (нумерация с 1)
    color := (diag - 2) mod k + 1;  // diag-2, потому что первая диагональ (2) -> цвет 1

    // Добавляем длину диагонали к соответствующему цвету
    colors[color] := colors[color] + len;
  end;

  // Вывод результатов
  for color := 1 to k do
    writeln(colors[color]);
end.
