﻿import sys

# Предварительно вычисляем is_good для всех чисел до 10**6
MAX = 10**6 + 1
is_good = [True] * MAX


# Для каждого простого p проверяем степени в числах
for p in range(2, MAX):
    if is_good[p]:  # p — простое (ещё не помечено)
        # Помечаем кратные p^2, p^4, ... как НЕ нечётно-степенные
        p2 = p * p
        for multiple in range(p2, MAX, p2):
            is_good[multiple] = False
        # Также проверяем p^3, p^5, ... (но они уже покрыты выше)
        # На самом деле достаточно p^2: если число делится на p^2, то степень p в нём чётная или >1, но нам важно, что >=2 и чётная

# Теперь is_good[n] == True, если n — нечётно-степенное

m = int(input())
l, r = map(int, input().split())

# Строим good_count для отрезка [l, r]
good_count = [0] * (r + 1)
for i in range(l, r + 1):
    if is_good[i]:
        good_count[i] = good_count[i - 1] + 1 if i > l else 1
    else:
        good_count[i] = 0

# Ищем последовательность длины m
found = False
for start in range(l, r - m + 2):
    end = start + m - 1
    if good_count[end] >= m:
        # Выводим числа от start до end
        print(' '.join(map(str, range(start, end + 1))))
        found = True
        break

if not found:
    print(-1)
