﻿n, m, k = map(int, input().split())
L_min, L_max = min(n, m), max(n, m)
total_d = n + m - 1
colors = [0] * k

def sum_arithmetic(a, d, n):
    """Сумма арифметической прогрессии: a, a+d, ..., a+(n-1)*d"""
    return n * a + d * n * (n - 1) // 2

# Группа 1: d = 1..L_min, длина = d
for c in range(k):
    # Первый d: (d-1) mod k = c → d = c+1
    first_d = c + 1
    if first_d > L_min:
        continue
    # Последний d: ≤ L_min и ≡ c+1 mod k
    last_d = first_d + k * ((L_min - first_d) // k)
    count = (last_d - first_d) // k + 1
    colors[c] += sum_arithmetic(first_d, k, count)

# Группа 2: d = L_min+1..L_max, длина = L_min
if L_max > L_min:
    total_group2 = L_max - L_min
    for c in range(k):
        # Первый d в группе 2 с цветом c
        first_d = L_min + 1 + ((c - (L_min % k)) % k)
        if first_d > L_max:
            continue
        count = 1 + (L_max - first_d) // k
        colors[c] += count * L_min

# Группа 3: d = L_max+1..total_d, длина = n+m-d
start_d = L_max + 1
if start_d <= total_d:
    for c in range(k):
        # Первый d в группе 3 с цветом c
        first_d = start_d + ((c - ((start_d - 1) % k)) % k)
        if first_d > total_d:
            continue
        # Последний d с цветом c
        last_d = first_d + k * ((total_d - first_d) // k)
        count = (last_d - first_d) // k + 1
        # Сумма длин: (n+m-first_d) + (n+m-first_d-k) + ...
        first_len = n + m - first_d
        colors[c] += sum_arithmetic(first_len, -k, count)

for count in colors:
    print(count)
