import sys

MOD = 10**9 + 7

def modinv(a, mod=MOD):
    # Находим обратный элемент по модулю
    return pow(a, mod-2, mod)

def nCk(n, k, fact, inv_fact):
    if k < 0 or k > n:
        return 0
    return fact[n] * inv_fact[k] % MOD * inv_fact[n-k] % MOD

def solve_combinatorial(R_str, K):
    """
    Комбинаторное решение через биномиальные коэффициенты
    Считает количество чисел <= R с popcount ≡ 0 mod K
    """
    R_int = int(R_str)
    binary = bin(R_int)[2:]
    n = len(binary)
    
    # Предподсчёт факториалов
    max_n = n + 5
    fact = [1] * (max_n)
    for i in range(1, max_n):
        fact[i] = fact[i-1] * i % MOD
    
    inv_fact = [1] * (max_n)
    inv_fact[max_n-1] = modinv(fact[max_n-1])
    for i in range(max_n-2, -1, -1):
        inv_fact[i] = inv_fact[i+1] * (i+1) % MOD
    
    # Динамика по битам
    result = 0
    ones_so_far = 0
    
    for i, bit in enumerate(binary):
        if bit == '1':
            # Рассматриваем вариант, когда на текущей позиции стоит 0
            # Тогда оставшиеся позиции: n-i-1
            # Нужно выбрать количество единиц, чтобы (ones_so_far + ones_chosen) % K == 0
            remaining = n - i - 1
            
            for chosen_ones in range(remaining + 1):
                if (ones_so_far + chosen_ones) % K == 0:
                    result = (result + nCk(remaining, chosen_ones, fact, inv_fact)) % MOD
            
            # Переходим к случаю, когда на текущей позиции стоит 1
            ones_so_far += 1
    
    # Проверяем само число R
    if ones_so_far % K == 0:
        result = (result + 1) % MOD
    
    return result

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    
    n = int(data[0])
    K = int(data[1])
    R = data[2]
    
    if K == 1:
        # Все числа подходят
        result = (int(R) + 1) % MOD
        print(result)
        return
    
    # Если K слишком большое, многие числа не подойдут
    # Но R может быть огромным (до 10^30000)
    
    # Используем комбинаторный подход
    result = solve_combinatorial(R, K)
    print(result)

if __name__ == "__main__":
    solve()
