import sys

MOD = 10 ** 9 + 7


def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return

    n = int(data[0])
    K = int(data[1])
    R = data[2]

    # Если K = 1, то popcount всегда делится на 1, ответ - количество чисел от 0 до R
    if K == 1:
        # Количество чисел от 0 до R включительно это R + 1
        # Но R - строка, так что преобразуем
        result = (int(R) + 1) % MOD
        print(result)
        return

    # Преобразуем R в двоичную строку
    R_int = int(R)
    binary_R = bin(R_int)[2:]  # убираем '0b'
    bin_len = len(binary_R)

    # Динамика: dp[pos][tight][ones_mod] - количество способов
    # pos - текущая позиция в двоичном представлении
    # tight - флаг ограничения (1 - текущий префикс равен префиксу R, 0 - меньше)
    # ones_mod - остаток от деления количества единиц на K

    # Инициализация
    dp = [[[0] * K for _ in range(2)] for _ in range(bin_len + 1)]
    dp[0][1][0] = 1  # начальное состояние: позиция 0, tight=1, ones_mod=0

    for pos in range(bin_len):
        current_bit = int(binary_R[pos])
        for tight in range(2):
            for ones_mod in range(K):
                current_count = dp[pos][tight][ones_mod]
                if current_count == 0:
                    continue

                # Определяем максимальную цифру на текущей позиции
                max_digit = 1 if (tight == 0) else current_bit

                for digit in range(max_digit + 1):
                    next_tight = 1 if (tight == 1 and digit == current_bit) else 0
                    next_ones_mod = (ones_mod + digit) % K
                    dp[pos + 1][next_tight][next_ones_mod] = (
                                                                     dp[pos + 1][next_tight][
                                                                         next_ones_mod] + current_count
                                                             ) % MOD

    # Ответ: сумма по всем tight (0 и 1) где ones_mod == 0
    # Но нужно вычесть 0, если он не входит? Нет, 0 входит (popcount(0)=0 делится на K)
    result = (dp[bin_len][0][0] + dp[bin_len][1][0]) % MOD
    print(result)


if __name__ == "__main__":
    solve()
