MOD = 10 ** 9 + 7


def solve(R_str, K):
    n = len(R_str)
    dp = [[[-1] * 2 for _ in range(K)] for __ in range(n)]

    def dfs(pos, rem, tight):
        if pos == n:
            return 1 if rem == 0 else 0

        if dp[pos][rem][tight] != -1:
            return dp[pos][rem][tight]

        max_digit = int(R_str[n - 1 - pos]) if tight else 9
        res = 0
        for digit in range(max_digit + 1):
            new_tight = tight & (digit == max_digit)
            bin_rep = format(digit, 'b')
            ones_in_digit = sum(1 for ch in bin_rep if ch == '1')
            new_rem = (rem + ones_in_digit) % K
            res = (res + dfs(pos + 1, new_rem, new_tight)) % MOD

        dp[pos][rem][tight] = res
        return res

    ans = dfs(0, 0, True)
    return ans


# Чтение входных данных
n, K = map(int, input().split())
R = input()

# Вычисляем ответ
answer = solve(R, K)
print(answer)
