import sys
import math


def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return

    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    # Решето для определения нечётно-степенных чисел
    # is_good[i] = True, если i - нечётно-степенное число
    n = r
    is_good = [True] * (n + 1)
    is_good[0] = False

    # Воспользуемся тем фактом, что число нечётно-степенное тогда и только тогда,
    # когда оно НЕ делится ни на один квадрат простого числа p^2
    # И также не имеет простых делителей в четной степени (что автоматически следует)

    for i in range(2, int(math.sqrt(n)) + 1):
        if i * i > n:
            break
        # Если i простое
        if is_good[i]:
            square = i * i
            # Все числа, содержащие i^2, не являются нечётно-степенными
            for j in range(square, n + 1, square):
                is_good[j] = False

    # Теперь is_good[i] = True только для чисел, которые не делятся на квадраты простых
    # Это как раз нечётно-степенные числа (все простые входят в нечётной степени)

    # Ищем последовательность длины m
    count = 0
    start = -1

    for num in range(l, r + 1):
        if is_good[num]:
            count += 1
            if count >= m:
                start = num - m + 1
                break
        else:
            count = 0

    if start == -1:
        print(-1)
    else:
        result = ' '.join(str(start + i) for i in range(m))
        print(result)


if __name__ == "__main__":
    solve()
