from math import isqrt

def sieve(limit):
    """Решето Эратосфена для нахождения простых чисел до заданного лимита."""
    primes = [True] * (limit + 1)
    primes[0], primes[1] = False, False
    for i in range(2, isqrt(limit)):
        if primes[i]:
            for j in range(i*i, limit+1, i):
                primes[j] = False
    return [p for p, flag in enumerate(primes) if flag]

def precompute_is_odd_powered(limit):
    """
    Предрасчёт всех нечётно-степенных чисел до указанного предела.
    Возвращает булевый массив, где индекс соответствует числу.
    """
    odd_powers = [False] * (limit + 1)
    primes = sieve(limit)
    for num in range(2, limit+1):
        factorizations = {}
        temp_num = num
        idx = 0
        while temp_num > 1 and idx < len(primes):
            p = primes[idx]
            cnt = 0
            while temp_num % p == 0:
                temp_num //= p
                cnt += 1
            if cnt > 0:
                factorizations[p] = cnt
            idx += 1
        if temp_num > 1:
            factorizations[temp_num] = 1
        odd_powers[num] = all(cnt % 2 != 0 for cnt in factorizations.values())
    return odd_powers

def find_consecutive_numbers(m, l, r):
    """
    Поиск m последовательных нечётно-степенных чисел на промежутке [l, r].
    """
    if m <= 10 or r <= 10**3:  # Маленький диапазон или маленькое значение m
        def check_number(n):
            factors = {}
            temp_n = n
            for p in range(2, isqrt(temp_n)+1):
                cnt = 0
                while temp_n % p == 0:
                    temp_n //= p
                    cnt += 1
                if cnt > 0 and cnt % 2 == 0:
                    return False
            if temp_n != 1 and temp_n % 2 != 0:
                factors[temp_n] = 1
            return all(v % 2 != 0 for v in factors.values())

        for start in range(l, r-m+2):
            seq = list(range(start, start+m))
            if all(check_number(x) for x in seq):
                return seq
    else:  # Большие размеры диапазона и большое m
        precomputed = precompute_is_odd_powered(r)
        for start in range(l, r-m+2):
            seq = list(range(start, start+m))
            if all(precomputed[x] for x in seq):
                return seq
    return None

# Основная программа
m = int(input())  # Количество последовательных чисел
l, r = map(int, input().split())  # Границы диапазона

sequence = find_consecutive_numbers(m, l, r)

if sequence:
    print(" ".join(map(str, sequence)))
else:
    print("-1")
